<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\Analytics;

class WebPropertySummary extends \Google\Site_Kit_Dependencies\Google\Collection
{
    protected $collection_key = 'profiles';
    /**
     * @var string
     */
    public $id;
    /**
     * @var string
     */
    public $internalWebPropertyId;
    /**
     * @var string
     */
    public $kind;
    /**
     * @var string
     */
    public $level;
    /**
     * @var string
     */
    public $name;
    protected $profilesType = \Google\Site_Kit_Dependencies\Google\Service\Analytics\ProfileSummary::class;
    protected $profilesDataType = 'array';
    /**
     * @var bool
     */
    public $starred;
    /**
     * @var string
     */
    public $websiteUrl;
    /**
     * @param string
     */
    public function setId($id)
    {
        $this->id = $id;
    }
    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * @param string
     */
    public function setInternalWebPropertyId($internalWebPropertyId)
    {
        $this->internalWebPropertyId = $internalWebPropertyId;
    }
    /**
     * @return string
     */
    public function getInternalWebPropertyId()
    {
        return $this->internalWebPropertyId;
    }
    /**
     * @param string
     */
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    /**
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * @param string
     */
    public function setLevel($level)
    {
        $this->level = $level;
    }
    /**
     * @return string
     */
    public function getLevel()
    {
        return $this->level;
    }
    /**
     * @param string
     */
    public function setName($name)
    {
        $this->name = $name;
    }
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * @param ProfileSummary[]
     */
    public function setProfiles($profiles)
    {
        $this->profiles = $profiles;
    }
    /**
     * @return ProfileSummary[]
     */
    public function getProfiles()
    {
        return $this->profiles;
    }
    /**
     * @param bool
     */
    public function setStarred($starred)
    {
        $this->starred = $starred;
    }
    /**
     * @return bool
     */
    public function getStarred()
    {
        return $this->starred;
    }
    /**
     * @param string
     */
    public function setWebsiteUrl($websiteUrl)
    {
        $this->websiteUrl = $websiteUrl;
    }
    /**
     * @return string
     */
    public function getWebsiteUrl()
    {
        return $this->websiteUrl;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\Analytics\WebPropertySummary::class, 'Google\\Site_Kit_Dependencies\\Google_Service_Analytics_WebPropertySummary');
